USE [EleriumClean]
GO

/****** Object:  Table [dbo].[StoreItem]    Script Date: 10/3/2013 8:16:20 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[StoreItem](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[AvatarID] [int] NULL,
	[StoreCategoryID] [int] NOT NULL,
	[StoreCurrencyID] [int] NOT NULL,
	[AllowRefunds] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[DisplayOrder] [tinyint] NOT NULL,
	[EmailAddressLabel] [nvarchar](32) NULL,
	[IsAvailable] [bit] NOT NULL,
	[IsAutomaticallyFulfilled] [bit] NOT NULL,
	[IsEmployeeOnly] [bit] NOT NULL,
	[LegalText] [nvarchar](max) NULL,
	[Name] [nvarchar](128) NOT NULL,
	[Price] [money] NOT NULL,
	[RequiresItemCodes] [bit] NOT NULL,
	[RequiresEmailAddress] [bit] NOT NULL,
 CONSTRAINT [PK_StoreItem] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

ALTER TABLE [dbo].[StoreItem] ADD  CONSTRAINT [DF_StoreItem_AllowRefunds]  DEFAULT ((0)) FOR [AllowRefunds]
GO

ALTER TABLE [dbo].[StoreItem] ADD  CONSTRAINT [DF_StoreItem_DateCreated]  DEFAULT (getutcdate()) FOR [DateCreated]
GO

ALTER TABLE [dbo].[StoreItem] ADD  CONSTRAINT [DF_StoreItem_DateModified]  DEFAULT (getutcdate()) FOR [DateModified]
GO

ALTER TABLE [dbo].[StoreItem] ADD  CONSTRAINT [DF_StoreItem_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
GO

ALTER TABLE [dbo].[StoreItem] ADD  CONSTRAINT [DF_StoreItem_IsAvailable]  DEFAULT ((0)) FOR [IsAvailable]
GO

ALTER TABLE [dbo].[StoreItem] ADD  CONSTRAINT [DF_StoreItem_RequiresEmail]  DEFAULT ((0)) FOR [RequiresEmailAddress]
GO

ALTER TABLE [dbo].[StoreItem]  WITH CHECK ADD  CONSTRAINT [FK_StoreItem_Avatar] FOREIGN KEY([AvatarID])
REFERENCES [dbo].[Avatar] ([ID])
GO

ALTER TABLE [dbo].[StoreItem] CHECK CONSTRAINT [FK_StoreItem_Avatar]
GO

ALTER TABLE [dbo].[StoreItem]  WITH CHECK ADD  CONSTRAINT [FK_StoreItem_StoreCategory] FOREIGN KEY([StoreCategoryID])
REFERENCES [dbo].[StoreCategory] ([ID])
GO

ALTER TABLE [dbo].[StoreItem] CHECK CONSTRAINT [FK_StoreItem_StoreCategory]
GO

ALTER TABLE [dbo].[StoreItem]  WITH CHECK ADD  CONSTRAINT [FK_StoreItem_StoreCurrency] FOREIGN KEY([StoreCurrencyID])
REFERENCES [dbo].[StoreCurrency] ([ID])
GO

ALTER TABLE [dbo].[StoreItem] CHECK CONSTRAINT [FK_StoreItem_StoreCurrency]
GO


